# flexoentity

**flexoentity** is the foundational Python library of the *Flex-O* ecosystem.

It provides:
- `FlexOID`: a deterministic, state-aware, and versioned identifier system
- `FlexoEntity`: a base class for reproducible, lifecycle-tracked domain entities

Together, these components ensure traceability, immutability, and auditability
across the Flex-O-Grader, Flex-O-Vault, and Flex-O-Drill projects.

### Example

```python
from flexoentity import FlexOID, FlexoEntity

question = FlexoEntity(
    domain="AF",
    etype="Q",
    text="What is Ohm’s law?",
    state="A"
)
print(question.flexo_id)

Features
	•	BLAKE2s hashing (fast, stdlib, deterministic)
	•	Canonical seed generation
	•	Lifecycle state encoding (@001A)
	•	UTC-based timestamps
	•	Collision disambiguation

Licensed under the MIT License.
