from flexoentity.flexo_collection import FlexoCollection
from flexoentity import FlexoEntity

class TypedCollection(FlexoCollection):
    """
    A type-safe collection of FlexOEntity subclasses.
    """

    def __init__(self, entity_class, items=None):
        if not issubclass(entity_class, FlexoEntity):
            raise TypeError("entity_class must be a subclass of FlexOEntity")

        self.entity_class = entity_class
        super().__init__()

        if items:
            for e in items:
                self.add(e)

    def add(self, entity: FlexoEntity, key=None):
        if not isinstance(entity, self.entity_class):
            raise TypeError(
                f"TypedCollection[{self.entity_class.__name__}] "
                f"cannot accept {type(entity).__name__}"
            )
        super().add(entity, key)

    # ------------------------------------------------------------------
    # Deserialization
    # ------------------------------------------------------------------
    @classmethod
    def deserialize(cls, entity_class, list_of_dicts):
        """
        Create a TypedCollection of `entity_class` from a list of dicts.
        """
        # create empty collection
        coll = cls(entity_class)

        # build entity objects
        for d in list_of_dicts:
            entity = entity_class.from_dict(d)
            coll.add(entity)

        return coll
