"""
flexoentity — Core entities and ID system of the Flex-O ecosystem.

Includes:
- FlexOID: deterministic, versioned, and state-aware ID generator
- FlexoEntity: lifecycle-tracked base class for all Flex-O domain objects
"""
# FIXME: change the default log path to /var/log/ammos/ammos.log when system
# configuration created this dir with the appropriate rights

from importlib.metadata import version, PackageNotFoundError
from .logger import logger
from .id_factory import FlexOID, canonical_seed
from .flexo_entity import FlexoEntity, EntityType, EntityState
from .flexo_collection import FlexoCollection
from .typed_collection import TypedCollection
from .in_memory_backend import InMemoryBackend
from .composite_backend import CompositeBackend
from .entity_manager import EntityManager
from .sqlite_entity_backend import SQLiteEntityBackend
from .domain import Domain
from .domain_manager import DomainManager, DuplicateDomainError
from .flexo_signature import FlexoSignature, CertificateReference
from .entity_registry import EntityRegistry
from .signing_backends import get_signing_backend

__all__ = [
    "FlexOID",
    "canonical_seed",
    "FlexoEntity",
    "EntityType",
    "Domain",
    "EntityManager",
    "SQLiteEntityBackend",
    "InMemoryBackend",
    "CompositeBackend",
    "DomainManager",
    "DuplicateDomainError",
    "EntityState",
    "FlexoCollection",
    "TypedCollection",
    "FlexoSignature",
    "EntityRegistry",
    "CertificateReference",
    "get_signing_backend",
    "logger"
]

# Optional: keep dynamic version retrieval synced with pyproject.toml
try:
    __version__ = version("flexoentity")
except PackageNotFoundError:
    __version__ = "0.0.0-dev"
