class PersistanceBackend:
    """
    Interface for all persistence backends.

    Stores serialized FlexOEntity dicts with a flexo_id key.
    """

    def save(self, entity_dict: dict) -> None:
        raise NotImplementedError

    def update(self, entity_dict: dict) -> None:
        raise NotImplementedError

    def delete(self, flexo_id: str) -> None:
        raise NotImplementedError

    def load(self, flexo_id: str) -> dict | None:
        raise NotImplementedError

    def load_all(self) -> list[dict]:
        raise NotImplementedError

    def clear(self):
        """Remove all stored entities."""
        raise NotImplementedError
