import tkinter as tk
from tkinter import simpledialog, ttk


class ExamDialog(simpledialog.Dialog):

    def __init__(self, parent, title=None, exam=None):
        self.exam = exam  # may be None
        self.result = None
        super().__init__(parent, title)

    def body(self, master):
        row = 0

        # ─────────────────────────────
        # Basic metadata
        # ─────────────────────────────
        ttk.Label(master, text="Title:").grid(row=row, column=0, sticky="w")
        self.title_entry = ttk.Entry(master, width=40)
        self.title_entry.grid(row=row, column=1, sticky="ew")
        row += 1

        ttk.Label(master, text="Author:").grid(row=row, column=0, sticky="w")
        self.author_entry = ttk.Entry(master, width=40)
        self.author_entry.grid(row=row, column=1, sticky="ew")
        row += 1

        ttk.Label(master, text="Allowed Aids:").grid(row=row, column=0, sticky="w")
        self.allowed_aids_entry = ttk.Entry(master, width=40)
        self.allowed_aids_entry.grid(row=row, column=1, sticky="ew")
        row += 1

        ttk.Label(master, text="Duration:").grid(row=row, column=0, sticky="w")
        self.duration_entry = ttk.Entry(master, width=40)
        self.duration_entry.grid(row=row, column=1, sticky="ew")
        row += 1

        # ─────────────────────────────
        # Intro / submission notes
        # ─────────────────────────────
        ttk.Label(master, text="Intro note:").grid(row=row, column=0, sticky="nw")
        self.intro_text = tk.Text(master, width=40, height=4)
        self.intro_text.grid(row=row, column=1, sticky="ew")
        row += 1

        ttk.Label(master, text="Submission note:").grid(row=row, column=0, sticky="nw")
        self.submission_text = tk.Text(master, width=40, height=4)
        self.submission_text.grid(row=row, column=1, sticky="ew")
        row += 1

        # ─────────────────────────────
        # Structural defaults
        # ─────────────────────────────
        has_id_form = self.exam.has_id_form() if self.exam is not None else True
        self.var_id_form = tk.BooleanVar(value=has_id_form)
        self.var_instruction_block = tk.BooleanVar(value=True)

        ttk.Checkbutton(
            master,
            text="Include candidate ID form",
            variable=self.var_id_form
        ).grid(row=row, column=1, sticky="w")
        row += 1

        if self.exam is not None:

            self.title_entry.insert(0, self.exam.title or "")
            self.author_entry.insert(0, self.exam.author or "")
            self.allowed_aids_entry.insert(0, self.exam.allowed_aids or "")
            self.duration_entry.insert(0, self.exam.duration or "")

            if self.exam.intro_note:
                self.intro_text.insert("1.0", self.exam.intro_note)

            if getattr(self.exam, "submission_note", None):
                self.submission_text.insert("1.0", self.exam.submission_note)

        return self.title_entry  # initial focus

    def apply(self):
        self.result = {
            "title": self.title_entry.get().strip(),
            "author": self.author_entry.get().strip(),
            "allowed_aids": self.allowed_aids_entry.get().strip(),
            "duration": self.duration_entry.get().strip(),
            "intro_note": self.intro_text.get("1.0", "end").strip(),
            "submission_note": self.submission_text.get("1.0", "end").strip(),
            "include_id_form": self.var_id_form.get(),
        }
