from .persistance_backend import PersistanceBackend
from .flexo_entity import FlexoEntity


class RuntimeBackend(PersistanceBackend):
    """
    Runtime backend.

    - Stores entity *instances*
    - Guarantees identity stability
    - No serialization
    - No reconstruction
    """

    def __init__(self, entity_class):
        if not issubclass(entity_class, FlexoEntity):
            raise TypeError("entity_class must be a subclass of FlexoEntity")

        super().__init__(entity_class=entity_class)
        self._store: dict[str, FlexoEntity] = {}

    def save(self, entity):
        self._store[entity.flexo_id] = entity

    def update(self, entity):
        self._store[entity.flexo_id] = entity

    def delete(self, flexo_id: str):
        self._store.pop(flexo_id, None)

    def load(self, flexo_id: str):
        return self._store.get(flexo_id)

    def load_all(self):
        return list(self._store.values())

    def clear(self):
        self._store.clear()
