import pytest
from flexoentity.in_memory_backend import InMemoryBackend
from flexoentity.domain import Domain




def test_save_and_load_roundtrip(local_backend, sample_domain):
    local_backend.save(sample_domain)

    loaded = local_backend.load(sample_domain.flexo_id)
    assert isinstance(loaded, Domain)
    # important: entity equality is probably identity-based, so compare dicts:
    assert loaded.to_dict() == sample_domain.to_dict()


def test_update_overwrites_entity(local_backend, sample_domain):
    local_backend.save(sample_domain)

    # change something
    sample_domain.description = "UPDATED DESC"
    local_backend.update(sample_domain)

    loaded = local_backend.load(sample_domain.flexo_id)
    assert loaded.description == "UPDATED DESC"


def test_delete_removes_entity(local_backend, sample_domain):
    local_backend.save(sample_domain)
    local_backend.delete(sample_domain.flexo_id)

    assert local_backend.load(sample_domain.flexo_id) is None
    assert local_backend.load_all() == []


def test_clear_removes_all(local_backend, sample_domain):
    local_backend.save(sample_domain)
    local_backend.clear()

    assert local_backend.load(sample_domain.flexo_id) is None
    assert local_backend.load_all() == []
