class EntityRegistry:
    """
    Central authority for accessing all FlexoEntities.
    Works with in-memory managers today,
    and can be extended to SQLite later.
    """

    def __init__(self):
        self._sources = []  # list of callables

    def register_source(self, func):
        """Register a callable that returns a list or iterable of entities."""
        if not callable(func):
            raise TypeError("Source must be callable")
        self._sources.append(func)

    def all_entities(self):
        """Iterate over all known entities."""
        for src in self._sources:
            for e in src():
                yield e

    def entities_by_domain(self, domain_id):
        for e in self.all_entities():
            if e.flexo_id.domain_id == domain_id:
                yield e
