from dataclasses import dataclass
from flexoentity.flexo_entity import FlexoEntity, EntityType, EntityState


@dataclass
class Domain(FlexoEntity):
    fullname: str = ""
    description: str = ""
    classification: str = "UNCLASSIFIED"
    owner: str = "unknown"

    @classmethod
    def default(cls):
        return cls(domain="GEN", entity_type=EntityType.DOMAIN, state=EntityState.DRAFT)

    def __post_init__(self):
        super().__post_init__()

    @property
    def text_seed(self) -> str:
        """Deterministic text seed for ID generation."""
        return f"{self.fullname}|{self.classification}|{self.owner}"

    def to_dict(self):
        base = super().to_dict()
        base.update({
            "fullname": self.fullname,
            "description": self.description,
            "classification": self.classification,
            "owner": self.owner
        })
        return base

    @classmethod
    def from_dict(cls, data):
        return cls(
            fullname=data.get("fullname", ""),
            description=data.get("description", ""),
            classification=data.get("classification", "UNCLASSIFIED"),
            owner=data.get("owner", "unknown"),
        )
