#!/usr/bin/env python3

from flexoentity.domain import Domain
from flexoentity.json_file_backend import JsonFileBackend


def make_domain(domain_id="PY_ARITHM"):
    return Domain.with_domain_id(
        subtype="Domain",
        domain_id=domain_id,
        fullname="PYTHON_ARITHMETIC",
        description="ALL ABOUT ARITHMETIC IN PYTHON",
        classification="UNCLASSIFIED",
    )


def test_jsonfile_roundtrip(tmp_path):
    path = tmp_path / "domains.json"
    backend = JsonFileBackend(Domain, path)

    dom1 = make_domain("PY_ARITHM")
    dom2 = make_domain("PY_STRINGS")

    backend.save(dom1)
    backend.save(dom2)
    backend.flush_to_file()

    # new instance simulating a reload
    backend2 = JsonFileBackend(Domain, path)
    backend2.load_from_file()

    loaded = backend2.load_all()
    ids = sorted(d.domain_id for d in loaded)
    assert ids == ["PY_ARITHM", "PY_STRINGS"]
