import sqlite3
from flexoentity.domain import Domain
from flexoentity import SQLiteEntityBackend


def make_domain(domain_id="PY_ARITHM"):
    return Domain.with_domain_id(
        subtype="Domain",
        domain_id=domain_id,
        fullname="PYTHON_ARITHMETIC",
        description="ALL ABOUT ARITHMETIC IN PYTHON",
        classification="UNCLASSIFIED",
    )


def test_sqlite_roundtrip(tmp_path):
    db_path = tmp_path / "domains.db"
    conn = sqlite3.connect(db_path)
    conn.row_factory = sqlite3.Row

    backend = SQLiteEntityBackend(Domain, conn, table_name="domains")

    dom = make_domain()
    backend.save(dom)

    loaded = backend.load(dom.flexo_id)
    assert loaded.to_dict() == dom.to_dict()

    all_loaded = backend.load_all()
    assert len(all_loaded) == 1
    assert all_loaded[0].domain_id == "PY_ARITHM"
