"""
flexoentity — Core entities and ID system of the Flex-O ecosystem.

Includes:
- FlexOID: deterministic, versioned, and state-aware ID generator
- FlexoEntity: lifecycle-tracked base class for all Flex-O domain objects
"""
from importlib.metadata import version, PackageNotFoundError
from .id_factory import FlexOID, canonical_seed
from .flexo_entity import FlexoEntity, EntityType, EntityState

__all__ = [
    "FlexOID",
    "canonical_seed",
    "FlexoEntity",
    "EntityType",
    "EntityState",
]

# Optional: keep dynamic version retrieval synced with pyproject.toml
try:
    __version__ = version("flexoentity")
except PackageNotFoundError:
    __version__ = "0.0.0-dev"
