import logging
import logging.config
import os
import tempfile
from pathlib import Path


log_dir = Path(os.environ.get('FLEXO_LOG_DIR', tempfile.gettempdir()))

log_path = log_dir / 'flexo.log'

if not log_path.exists():
    try:
        log_path.touch()
    except PermissionError:
        conf_file = Path(__file__).parent / 'flexo_logging.conf'
        print("Conf file", conf_file)
        logging.config.fileConfig(conf_file)
else:
    logging.basicConfig(filename=str(log_path), encoding='utf-8', level=logging.DEBUG)

logger = logging.getLogger(__name__)

logger.setLevel(os.environ.get('FLEXO_LOG_LEVEL', logger.getEffectiveLevel()))
