"""
flexoentity — Core entities and ID system of the Flex-O ecosystem.

Includes:
- FlexOID: deterministic, versioned, and state-aware ID generator
- FlexoEntity: lifecycle-tracked base class for all Flex-O domain objects
"""
from importlib.metadata import version, PackageNotFoundError
from .id_factory import FlexOID, canonical_seed
from .flexo_entity import FlexoEntity, EntityType, EntityState
from .domain import Domain
import logging
import logging.config
import os
from pathlib import Path

__all__ = [
    "FlexOID",
    "canonical_seed",
    "FlexoEntity",
    "EntityType",
    "Domain",
    "EntityState",
]

# FIXME: change the default log path to /var/log/ammos/ammos.log when system
# configuration created this dir with the appropriate rights

log_dir = Path(os.environ.get('FLEXO_LOG_DIR', '/tmp/'))

log_path = log_dir / 'flexo.log'

if not log_path.exists():
    try:
        log_path.touch()
    except PermissionError:
        conf_file = Path(__file__).parent / 'flexo_logging.conf'
        print("Conf file", conf_file)
        logging.config.fileConfig(conf_file)
else:
    logging.basicConfig(filename=str(log_path), encoding='utf-8', level=logging.DEBUG)

logger = logging.getLogger(__name__)

logger.setLevel(os.environ.get('FLEXO_LOG_LEVEL', logger.getEffectiveLevel()))
# Optional: keep dynamic version retrieval synced with pyproject.toml
try:
    __version__ = version("flexoentity")
except PackageNotFoundError:
    __version__ = "0.0.0-dev"
