# tests/conftest.py

import pytest
import json
from flexoentity import FlexoEntity, EntityType, EntityState


class DummyEntity(FlexoEntity):
    """Minimal concrete subclass for testing FlexoEntity logic."""

    def __init__(self, domain, etype, state, seed="DUMMY"):
        self._seed = seed
        super().__init__(domain, etype, state)

    @property
    def text_seed(self) -> str:
        return self._seed 

    @classmethod
    def from_dict(cls, data):
        """Ensure enums and seed are reconstructed correctly."""
        domain = data["domain"]
        etype = EntityType[data["etype"]] if isinstance(data["etype"], str) else data["etype"]
        state = EntityState[data["state"]] if isinstance(data["state"], str) else data["state"]
        seed = data.get("text_seed", "DUMMY-CONTENT")
        return cls(domain=domain, etype=etype, state=state, seed=seed)

    @classmethod
    def from_json(cls, data_str: str):
        return cls.from_dict(json.loads(data_str))
    
@pytest.fixture
def entity():
    """Generic FlexoEntity-like instance in draft state."""
    return DummyEntity(
        domain="AF",
        etype=EntityType.CATALOG,
        state=EntityState.DRAFT,
    )
