from .persistance_backend import PersistanceBackend


class RuntimeBackend(PersistanceBackend):
    """
    Runtime backend (Option A).

    - Stores dicts only (no entity instances)
    - Useful as an in-process cache
    """

    def __init__(self, entity_class):
        super().__init__(entity_class=entity_class)
        self._store: dict[str, dict] = {}

    def save(self, entity_dict: dict):
        self._store[entity_dict["meta"]["flexo_id"]] = entity_dict

    def update(self, entity_dict: dict):
        self.save(entity_dict)

    def delete(self, flexo_id: str):
        self._store.pop(flexo_id, None)

    def load(self, flexo_id: str):
        return self._store.get(flexo_id)

    def load_all(self):
        return list(self._store.values())

    def clear(self):
        self._store.clear()
