import sqlite3
from flexoentity.domain import Domain
from flexoentity import SQLiteEntityBackend


def test_sqlite_roundtrip(tmp_path, sample_domain):
    db_path = tmp_path / "domains.db"
    conn = sqlite3.connect(db_path)
    conn.row_factory = sqlite3.Row

    backend = SQLiteEntityBackend(Domain, conn, table_name="domains")

    backend.save(sample_domain.to_dict())

    loaded = backend.load(sample_domain.flexo_id)
    assert loaded == sample_domain.to_dict()

    all_loaded = backend.load_all()
    assert len(all_loaded) == 1
    assert Domain.from_dict(all_loaded[0]).domain_id == "PY_ARITHM"
