# tests/conftest.py

import pytest
import json
from flexoentity import FlexoEntity, EntityType, EntityState, Domain

import pytest
import json
from flexoentity import EntityType, EntityState, Domain
from builder.questions import RadioQuestion, AnswerOption  # adjust path if different
from builder.media_items import NullMediaItem  # adjust import if needed


@pytest.fixture(scope="session")
def domain():
    """Provide a reusable domain for all entity tests."""
    return Domain(
        domain="SIG",
        etype=EntityType.DOMAIN,
        state=EntityState.DRAFT,
        fullname="Signal Corps",
        description="Questions related to communications and signaling systems.",
        classification="RESTRICTED",
        owner="test-suite"
    )


@pytest.fixture
def radio_question(domain):
    """Return a simple RadioQuestion entity for testing FlexoEntity logic."""
    q = RadioQuestion(
        domain=domain,
        etype=EntityType.QUESTION,
        state=EntityState.DRAFT,
        text="Which frequency band is used for shortwave communication?",
        options=[
            AnswerOption(id="opt1", text="HF (3–30 MHz)", points=1),
            AnswerOption(id="opt2", text="VHF (30–300 MHz)", points=0),
            AnswerOption(id="opt3", text="UHF (300–3000 MHz)", points=0),
        ]
    )
    return q


@pytest.fixture
def serialized_question(radio_question):
    """Provide the serialized JSON form for roundtrip tests."""
    return radio_question.to_json()


@pytest.fixture
def deserialized_question(serialized_question):
    """Recreate a question from JSON for consistency tests."""
    return RadioQuestion.from_json(serialized_question)


@pytest.fixture
def null_media():
    """Provide a default NullMediaItem instance for media tests."""
    return NullMediaItem(
        domain=domain,
        etype=EntityType.MEDIA,
        state=EntityState.DRAFT
    )
